<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

$wos = apms_options($options, $m_options);
$list = apms_cart_rows($wos);
$list_cnt = count($list);
if(!$list_cnt) {
	echo '<p class="text-muted text-center">장바구니가 비어 있습니다.</p>'.PHP_EOL;
	return;
}

// 효과
switch($wos['carousel']) {
	case 'fade'		: $effect = ' slide at-fade'; break;
	case 'up'		: $effect = ' slide at-vertical'; break;
	case 'slide'	: $effect = ' slide'; break;
	case 'show'		: $effect = ''; break;
	default			: $effect = ' slide'; break;
}

// 효과시간
$interval = ($wos['interval']) ? $wos['interval'] : 5000;

// Random Ticker Id
$carousel_id = apms_id();

// 이미지 비율
$img_height = ($wos['thumb_w'] > 0 && $wos['thumb_h'] > 0) ? round(($wos['thumb_h'] / $wos['thumb_w']) * 100, 2) : 100;

?>

<div class="carousel<?php echo $effect;?> widget-carousel widget-cart" id="<?php echo $carousel_id;?>" data-ride="carousel" data-interval="<?php echo $interval;?>">

	<div class="carousel-nav">
		<a class="left" href="#<?php echo $carousel_id;?>" role="button" data-slide="prev"><i class="fa fa-angle-left"></i></a>
		<a class="right" href="#<?php echo $carousel_id;?>" role="button" data-slide="next"><i class="fa fa-angle-right"></i></a>
	</div>

	<!-- Wrapper for slides -->
	<div class="carousel-inner">
		<div class="item active">
			<div class="row">
				<?php for($i=0; $i < $list_cnt; $i++) { ?>
					<?php if($i > 0 && $i%4 == 0) { ?>
							</div>
						</div>
						<div class="item">
							<div class="row">
					<?php } ?>
						<div class="col-xs-3 col">
							<div class="img" style="padding-bottom:<?php echo $img_height;?>%;">
								<a href="<?php echo $list[$i]['href'];?>" title="<?php echo $list[$i]['alt'];?>">
									<img src="<?php echo $list[$i]['img'];?>" alt="<?php echo $list[$i]['alt'];?>">
								</a>
							</div>
						</div>
				<?php } ?>
			</div>
		</div>
	</div>
</div>
